/*
  LuxTag Film.js
  
  
*/

// global variables.
var version_num = "0.1";

var tonemap_kernels = ["reinhard","linear","contrast","maxwhite"];

var exr_channels = ['RGB', 'RGBA', 'YA', 'Y'];
var exr_compressiontypes = ['PIZ (lossless)', 'RLE (lossless)', 'ZIP (lossless)', 'Pxr24 (lossy)', 'None'];
var exr_normalizationtypes = ["None", "Min/Max", "Camera Start/End clip"];
var png_channels = ['RGB', 'RGBA', 'YA', 'Y'];
var tga_channels = ['RGB', 'RGBA', 'Y'];

// presets
var colorspaces = ["sRGB - HDTV (ITU-R BT.709-5)", "ROMM RGB", "Adobe RGB 98", "Apple RGB", "NTSC (FCC 1953, ITU-R BT.470-2 System M)", "NTSC (1979) (SMPTE C, SMPTE-RP 145)", "PAL/SECAM (EBU 3213, ITU-R BT.470-6)", "CIE (1931) E"];
var whitepoints = ["E", "D50", "D55", "D65", "D75", "A", "B", "C", "9300"]; //, "F2", "F7", "F11"];

function buildUI( tag ) {

	tag.addParameterSeparator("[ Film ]");
	tag.addParameterInt("haltspp", 0, 0, 32768, false, false);
	tag.addParameterBool("premultiplyalpha", 0, 0, 1, false, false);
	
	tag.addParameterSelector("tonemap kernel", tonemap_kernels, false, false);
	
	tag.addParameterSeparator("tonemap reinhard");
	tag.addParameterBool("reinhard_autoywa", 1, 0, 1, false, false);
	tag.addParameterFloat("reinhard_ywa", 0.1, 0.001, 1.0, false, false);
	tag.addParameterFloat("reinhard_prescale", 1, 0, 10, false, false);
	tag.addParameterFloat("reinhard_postscale", 1, 0, 10, false, false);
	tag.addParameterFloat("reinhard_burn", 6, 0.1, 12, false, false);
	
	tag.addParameterSeparator("tonemap linear");
	tag.addParameterFloat("linear_sensitivity", 50.0, 0.0, 1000.0, false, false);
	tag.addParameterFloat("linear_exposure", 1.0, 0.001, 1.0, false, false);
	tag.addParameterFloat("linear_fstop", 2.8, 0.1, 64.0, false, false);
	tag.addParameterFloat("linear_gamma", 1.0, 0.0, 8.0, false, false);
	
	tag.addParameterSeparator("tonemap constrast");
	tag.addParameterFloat("contrast_ywa", 0.1, 0.001, 1.0, false, false);
	
	tag.addParameterSeparator("output option");

	tag.addParameterInt("displayinterval", 12, 4, 3600, false, false);
	tag.addParameterInt("writeinterval", 120, 12, 3600, false, false);
	
	tag.addParameterSeparator("output exr option");

	tag.addParameterBool("write_exr", 0, 0, 1, false, false);
	tag.addParameterSelector("write_exr_channels", exr_channels, false, false);
	tag.addParameterBool("write_exr_halftype", 1, 0, 1, false, false);
	tag.addParameterSelector("write_exr_compressiontype", exr_compressiontypes, false, false);
	tag.addParameterBool("write_exr_applyimaging", 1, 0, 1, false, false);
	tag.addParameterBool("write_exr_gamutclamp", 1, 0, 1, false, false);
	tag.addParameterBool("write_exr_ZBuf", 1, 0, 1, false, false); 
	tag.addParameterSelector("write_exr_zbugf_normalizationtype", exr_normalizationtypes, false, false);
	
	tag.addParameterSeparator("output png option");

	tag.addParameterBool("write_png", 1, 0, 1, false, false);
	tag.addParameterSelector("write_png_channels", png_channels, false, false);
	tag.addParameterBool("write_png_16bit", 0, 0, 1, false, false);
	tag.addParameterBool("write_png_gamutclamp", 1, 0, 1, false, false); // should use render pereference 'color clamp'.. how do I get?
	
	tag.addParameterSeparator("output tga option");

	tag.addParameterBool("write_tga", 0, 0, 1, false, false);
	tag.addParameterSelector("write_tga_channels", tga_channels, false, false);
	tag.addParameterBool("write_tga_gamutclamp", 1, 0, 1, false, false); // should use render pereference 'color clamp'.. how do I get?
	
	tag.addParameterSeparator("resume option");
	
	tag.addParameterBool("write_resume_flm", 0, 0, 1, false, false);
	tag.addParameterBool("restart_resume_flm", 0, 0, 1, false, false);
	
	tag.addParameterSeparator("reject & debug");
	tag.addParameterInt("reject_warmup", 128, 0, 32768, false, false);
	tag.addParameterBool("debug", 0, 0, 1, false, false);
	
	tag.addParameterSeparator("colorspace option");
	
	tag.addParameterFloat("cspacewhiteX", 0.314275, 0, 1, false, false);
	tag.addParameterFloat("cspacewhiteY", 0.329411, 0, 1, false, false);
	tag.addParameterFloat("cspaceredX", 0.63, 0, 1, false, false);
	tag.addParameterFloat("cspaceredY", 0.34, 0, 1, false, false);
	tag.addParameterFloat("cspacegreenX", 0.31, 0, 1, false, false);
	tag.addParameterFloat("cspacegreenY", 0.595, 0, 1, false, false);
	tag.addParameterFloat("cspaceblueX", 0.155, 0, 1, false, false);
	tag.addParameterFloat("cspaceblueY", 0.07, 0, 1, false, false);
	tag.addParameterFloat("gamma", 2.2, 0, 6, false, false);
	
	tag.addParameterSeparator("load colorspace preset");
	tag.addParameterSelector("colorspace", colorspaces, false, false);
	tag.addParameterButton("load colorspace preset", "load", "loadColorSpacePreset");
	tag.addParameterSelector("whitepoint", whitepoints, false, false);
	tag.addParameterButton("load whitepoint preset", "load", "loadWhitePointPreset");
	
	tag.setParameter("whitepoint", 3);
}

function loadColorSpacePreset( tag ) {
	var labels = ["cspacewhiteX","cspacewhiteY","cspaceredX","cspaceredY","cspacegreenX","cspacegreenY","cspaceblueX","cspaceblueY"];
	var preset = colorspaces[ parseInt( tag.getParameter("colorspace") ) ];
	
	switch (preset) {
		case 'sRGB - HDTV (ITU-R BT.709-5)':
			var vals = [0.314275, 0.329411, 0.63, 0.34, 0.31, 0.595, 0.155, 0.07]; //
			break;
		case 'ROMM RGB':
			var vals = [0.346, 0.359, 0.7347, 0.2653, 0.1596, 0.8404, 0.0366, 0.0001]; // D50
			break;
		case 'Adobe RGB 98':
			var vals = [0.313, 0.329, 0.64, 0.34, 0.21, 0.71, 0.15, 0.06]; // D65
			break;
		case 'Apple RGB':
			var vals = [0.313, 0.329, 0.625, 0.34, 0.28, 0.595, 0.155, 0.07]; // D65
			break;
		case 'NTSC (FCC 1953, ITU-R BT.470-2 System M)':
			var vals = [0.310, 0.316, 0.67, 0.33, 0.21, 0.71, 0.14, 0.08]; // C
			break;
		case 'NTSC (1979) (SMPTE C, SMPTE-RP 145)':
			var vals = [0.313, 0.329, 0.63, 0.34, 0.31, 0.595, 0.155, 0.07]; // D65
			break;
		case 'PAL/SECAM (EBU 3213, ITU-R BT.470-6)':
			var vals = [0.313, 0.329, 0.64, 0.33, 0.29, 0.60, 0.15, 0.06]; // D65
			break;
		case 'CIE (1931) E':
			var vals = [0.333, 0.333, 0.7347, 0.2653, 0.2738, 0.7174, 0.1666, 0.0089]; // E
			break;
	}
	for (var i = 0; i < labels.length; i++) {
		tag.setParameter( labels[i], vals[i] );
	}

}

function loadWhitePointPreset( tag ) {
	var labels = ["cspacewhiteX","cspacewhiteY"];
	var preset = whitepoints[ parseInt( tag.getParameter("whitepoint") ) ];
	
	switch( preset ) {
		case 'E':
			var vals = [0.346, 0.333];
			break;
		case 'D50':
			var vals = [0.346, 0.359];
			break;
		case 'D55':
			var vals = [0.332, 0.347];
			break;
		case 'D65':
			var vals = [0.313, 0.329];
			break;
		case 'D75':
			var vals = [0.299, 0.315];
			break;
		case 'A':
			var vals = [0.448, 0.407];
			break;
		case 'B':
			var vals = [0.348, 0.352];
			break;
		case 'C':
			var vals = [0.310, 0.316];
			break;
		case '9300':
			var vals = [0.285, 0.293];
			break;
		case 'F2':
			var vals = [0.372, 0.375];
			break;
		case 'F7':
			var vals = [0.313, 0.329];
			break;
		case 'F11':
			var vals = [0.381, 0.377];
			break;
	}
	for (var i = 0; i < labels.length; i++) {
		tag.setParameter( labels[i], vals[i] );
	}
}